# Ecommerce v5.1.1
**Release Date:** August 4, 2025  
**Tags:** SECURITY, CRITICAL FIXES, RATE LIMITING

## Critical Security Fixes

### Path Traversal Vulnerability (CVE-PENDING)
- **Fixed** critical path traversal vulnerability in digital product download endpoints
- **Added** path sanitization and validation to prevent unauthorized file access
- **Implemented** secure file streaming with proper directory restrictions
- **Created** new secure download endpoint at `/api/ecommerce/download/[orderItemId]/file`

### Price Manipulation Prevention
- **Added** server-side price validation in order processing
- **Enhanced** inventory checks before order completion
- **Implemented** product status validation during checkout
- **Added** quantity validation to prevent negative or invalid amounts

### Inventory Race Conditions
- **Implemented** optimistic locking for inventory updates
- **Added** database transaction locks on wallet operations
- **Enhanced** atomic operations for order processing
- **Fixed** concurrent order issues that could lead to overselling

## New Features

### Rate Limiting System
- **Added** comprehensive rate limiting middleware
- **Implemented** order creation limits: 5 orders per 15 minutes per user
- **Added** discount validation limits: 20 requests per minute
- **Implemented** download limits: 10 downloads per hour
- **Added** rate limit headers in API responses

## Technical Improvements

### Security Enhancements
- All file paths now use environment-configured base directories
- Enhanced transaction isolation for financial operations
- Improved error handling with proper transaction rollbacks
- Added order status updates to mark completed orders

### Code Organization
- Created new middleware module for rate limiting
- Separated file streaming logic into dedicated endpoint
- Improved code modularity and maintainability

## Breaking Changes
- None

## Recommendations
- Review and update all existing product file paths to be relative
- Configure appropriate rate limits based on your traffic patterns
- Test download functionality after updating to ensure file access works correctly
- Monitor rate limit logs to adjust thresholds as needed