# Core v5.6.3

**Release Date:** January 6, 2025
**Tags:** BUG FIXES, ECOSYSTEM TRADING, ORDER MATCHING, FEE CALCULATIONS, WALLET MANAGEMENT, NOTIFICATIONS

## Fixed

### Ecosystem Order Matching

- **Partial Fill Fees**: Fixed sellers being charged full order fee instead of proportional fee on partial fills - now correctly charges only for the filled amount
- **Locked Funds Release**: Fixed buyer's funds staying locked forever on partial fills - proportional cost and fee now properly released from locked balance
- **Negative Balance**: Fixed trade balance going negative due to wallet data type conversion issues - now explicitly converts Decimal types to numbers for accurate arithmetic
- **Price Execution**: Fixed unfair price matching where buyers always got their price - now properly uses maker's price (whoever placed order first)
- **Unauthorized Credit**: Fixed orders executing even when wallet updates failed due to insufficient funds - matching now properly aborts when validation fails
- **Error Handling**: Fixed order matching continuing after wallet update errors - failed matches are now skipped and orders remain available for retry
- **Order Cancellation**: Fixed partial fill cancellation refunding incorrect amounts - users receiving more than they should when cancelling partially filled orders - now correctly refunds only the remaining unfilled portion

### Email Notifications

- **Email Verification**: Fixed email verification and deposit confirmation emails not being sent - added missing URL shortcode to template validation

### Trading Interface

- **Balance Display**: Fixed trading page showing only available balance instead of total balance - now displays total balance, locked amount, and available balance separately for better clarity
- **Chart Updates**: Fixed OHLCV (candlestick) data not broadcasting to WebSocket subscribers when orders are matched - corrected subscription filter property order to match frontend subscription format

## Improved

### Fee Model

- **Maker/Taker Fees**: Improved fee assignment to use industry-standard maker/taker model
  - Market orders now use taker fee (removes liquidity)
  - Limit orders that cross spread use taker fee (removes liquidity)
  - Limit orders that rest on book use maker fee (adds liquidity)
  - Previous behavior incorrectly assigned fees based on buy/sell side only

### Order Matching

- **Proportional Fees**: Enhanced fee calculations to properly handle partial fills
  - 10% order fill now charges 10% of the fee (was charging 100% before)
  - Locked funds released proportionally including fee portion
  - All calculations maintain 18 decimal precision for accuracy

### Wallet Operations

- **Balance Integrity**: Improved wallet update logic to prevent balance discrepancies
  - Fresh wallet data fetched before each update to prevent stale data bugs
  - Separate handling for order creation/cancellation vs order matching
  - Both balance and locked funds (inOrder) validated before updates

### Balance Display

- **Wallet Information**: Enhanced wallet endpoint to return comprehensive balance details
  - Total balance (balance + inOrder)
  - Amount locked in orders (inOrder)
  - Available/spendable balance
- **Trading Interface**: Improved balance display with clear breakdown of all balance components
  - Shows total owned balance prominently
  - Displays locked funds with lock icon when applicable
  - Highlights available balance in green for easy identification

## Added

### Trading Features

- **Maker/Taker Detection**: Added automatic detection of maker/taker status at order creation
  - System checks if limit order will immediately match (taker) or rest on book (maker)
  - Applies appropriate fee rate based on liquidity provision
  - Encourages market depth with lower maker fees
