# Core v5.5.5

**Release Date:** October 9, 2025
**Tags:** FEATURES, UX IMPROVEMENTS, DOCUMENTATION

## Added

### Settings & Configuration
- **Added** WalletConnect setup documentation ([wallet-connect-setup.html](docs/content/core/wallet-connect-setup.html))
- **Added** Logo configuration improvements (light/dark mode support)
- **Added** Settings synchronization hooks ([use-settings-sync.ts](frontend/hooks/use-settings-sync.ts))

### Documentation
- **Added** Scylla/Cassandra setup guide with 14 step-by-step screenshots
- **Added** API port configuration guide
- **Added** Authenticator setup guide
- **Added** Root terminal access guide


## Improved

### ICO Module
- **Improved** Investment form validation and UX
- **Improved** ICO offer page with better error handling

### Internationalization
- **Improved** Updated translations across 115+ languages with new withdrawal UI strings

### Authentication & Middleware
- **Improved** Auth middleware with better session handling
- **Improved** Extension store management

### Frontend Components
- **Improved** Logo components with better light/dark mode support
- **Improved** Navbar logo rendering
- **Improved** Settings hooks refactored for better performance

### Trading & Market Data
- **Improved** Implemented three-tier market type system (`spot`, `spot-eco`, `futures`) for proper WebSocket routing
- **Improved** Market selection now sets correct URL type (`type=spot-eco`) for ecosystem markets
- **Improved** All trading components now determine market type from URL parameters for immediate routing
- **Improved** WebSocket subscriptions now connect to correct endpoints based on market type
- **Improved** Removed extension availability check blocking eco market connections
- **Improved** Trades data symbol validation now properly checks wrapper object
- **Improved** Orders panel now handles both wrapped and direct array response formats from ecosystem endpoint
- **Improved** Ecosystem WebSocket polling reduced from 500ms to 2000ms for better performance
- **Improved** Ticker data caching to only broadcast when values change
- **Improved** Removed empty trades broadcasts to reduce unnecessary WebSocket traffic