# Version 5.5.1

**Release Date:** January 23, 2025
**Tags:** ECOSYSTEM IMPROVEMENTS, XMR INTEGRATION, DEPOSIT MONITORING, FRONTEND REFACTORING, WALLET DISPLAY, TRADING IMPROVEMENTS, P2P FIXES

## Fixed

### XMR Ecosystem Integration
- **API 500 Error**: Fixed "No enabled tokens found for this currency" error for XMR ecosystem wallet endpoint
- **Special Chain Handling**: Added exemption for XMR, TON, SOL, TRON, BTC, LTC, DOGE, DASH from network environment variable requirements
- **Token Filtering**: Updated `getActiveTokensByCurrency` function to properly handle special chains without network constraints
- **Ecosystem Token Retrieval**: Fixed `getEcosystemToken` function to handle undefined network for special chains

### XMR Deposit Monitoring
- **Dynamic Confirmation Updates**: Fixed XMR deposits not updating confirmation count dynamically in frontend
- **Real-time Broadcasting**: Added continuous WebSocket updates as confirmation count increases (0→1→2→...→6)
- **Pending Transaction Detection**: Now detects and broadcasts transactions immediately when they enter mempool (0 confirmations)
- **Update Interval**: Reduced monitoring interval from 60 to 30 seconds for more frequent confirmation updates
- **Confirmation Tracking**: Implemented proper tracking to only broadcast when confirmation count actually changes
- **Max Retries**: Increased max retries from 60 to 120 to maintain 60-minute monitoring window with faster intervals

### XMR RPC Configuration
- **Custom Port Support**: Added environment variables for custom XMR RPC URLs to handle non-standard ports
- **Environment Variables**: Added `XMR_DAEMON_RPC_URL` and `XMR_WALLET_RPC_URL` for full URL configuration
- **Debug Logging**: Added console logging of configured RPC URLs on service startup for easier debugging
- **Documentation Update**: Updated Monero documentation with new configuration options and troubleshooting guide

### Wallet Balance Display
- **Decimal Precision**: Fixed wallet balances showing 0 decimals instead of 8 decimals
- **Wallet List Page**: Added custom render function to show balance and inOrder amounts with 8 decimal places
- **Single Wallet Page**: Ensured all balance displays show 8 decimal precision
- **ECO Wallet Balances**: Fixed network-specific balance display to show 8 decimals
- **Cryptocurrency Support**: Essential for accurate display of small cryptocurrency amounts (especially XMR)

### Trade Page Issues
- **Console Log Cleanup**: Removed unnecessary console.log statements from trading components
- **WebSocket Logs**: Removed connection and message logs from tickers-ws service
- **Market Service Logs**: Removed futures extension warning logs
- **AI Investment Store**: Removed debug logs from AI investment store
- **Production Ready**: Cleaned up all debug logs that shouldn't be in production

### Wallet Fetching Bug
- **Ecosystem Wallet Detection**: Fixed ecosystem markets incorrectly fetching SPOT wallets instead of ECO wallets
- **Symbol Format Normalization**: Fixed symbol format mismatch (BTC-USDT vs BTC/USDT) preventing proper market detection
- **Market Type Detection**: Added isMarketEco state tracking to ensure correct wallet type is fetched
- **URL Symbol Handling**: Properly normalized symbols from URL format (hyphen) to market format (slash)

### URL Locale Preservation
- **Locale Lost on Navigation**: Fixed locale being removed from URL when clicking on markets
- **Routing Import**: Used usePathname from @/i18n/routing to preserve locale
- **Market Selection**: Updated markets panel to maintain locale in URLs
- **Trading Layout**: Fixed URL updates to preserve locale when switching markets

### Wallet Balance Caching
- **Cache Prevention**: Removed sessionStorage caching of wallet balances to prevent stale data
- **Market Switching**: Fixed wrong balance showing when switching between markets (e.g., BTC-WALLET showing BTC-USDT balance)
- **Immediate Updates**: Wallet data now clears immediately when switching markets
- **Periodic Refresh**: Added 30-second interval refresh for wallet balances on trade page

### XMR Withdrawal Issues
- **Batch Transfer Implementation**: Fixed XMR withdrawals to use batch transfer for sending to user and admin
- **Fee Calculation**: Fixed double fee deduction and arithmetic errors in withdrawal process
- **Admin Profit**: Properly split withdrawal fee between admin profit and network fee
- **Profit Recording**: Fixed duplicate admin profit recording for XMR withdrawals
- **Balance Verification**: Added proper balance checks including all fees before withdrawal

### P2P Offer Creation
- **Amount Input Field**: Fixed issue where users couldn't erase leading zero in amount field
- **Input Behavior**: Amount field now allows clearing and typing values like "100" without showing "0100"
- **Empty Field Support**: Input now properly handles empty string to allow users to clear the field completely

## Added

### XMR Service Features
- **Confirmation Requirements**: Set XMR to require 6 confirmations before crediting deposits
- **Blockchain Explorer**: Updated to use Blockchair instead of xmrchain.net for better UI
- **Processing Expiry**: Set transaction processing cache expiry to 30 minutes
- **Pending Transaction States**: Added support for broadcasting pending confirmation states to frontend

### Environment Configuration
- **XMR RPC URLs**: Added support for custom daemon and wallet RPC URLs via environment variables
- **Port Flexibility**: System now supports any custom port configuration for XMR services
- **Fallback Values**: Default ports (18081 for daemon, 18083 for wallet) if not configured

### Trading Features
- **Balance Precision Display**: Added market-based precision for balance display in trading panel
- **Smart Formatting**: Removes trailing zeros while keeping minimum 2 decimal places for readability
- **Responsive Balance Layout**: Balance display now stacks on small screens for better mobile experience
- **Visual Improvements**: Added font-medium styling and improved separator display

### XMR Withdrawal Features
- **Batch Transfer Support**: XMR withdrawals now send funds to both user and admin in single transaction
- **Admin Master Wallet Detection**: Automatically finds admin master wallet for fee collection
- **Fee Splitting Logic**: Network fees paid automatically, admin profit sent separately
- **Enhanced Logging**: Added detailed logging for withdrawal process debugging

## Updated

### Documentation
- **Monero Integration Guide**: Added custom port configuration section
- **Testing Examples**: Included examples for testing with non-standard ports
- **Troubleshooting**: Added port mismatch troubleshooting guide with solutions
- **.env.example**: Added new XMR URL configuration examples

### Frontend Components
- **Import Organization**: Centralized component imports through barrel export file
- **Props Interfaces**: Added TypeScript interfaces for all extracted components
- **Code Organization**: Better separation of concerns between business logic and UI components

## Technical Details

### XMR Monitoring Flow
1. Transaction enters mempool → Broadcasts with 0 confirmations
2. Monitor checks wallet every 30 seconds
3. If confirmations increased, broadcasts update via WebSocket
4. Frontend receives real-time updates and shows progress bar
5. At 6 confirmations, deposit is credited to user account

### Performance Improvements
- **Reduced Context Usage**: Component extraction reduced main file context
- **Faster Updates**: 30-second intervals provide better user experience
- **Efficient Broadcasting**: Only sends updates when confirmation count changes
- **Cache Management**: Proper cleanup of processed transactions after 30 minutes