# Version 5.5.0

**Release Date:** January 13, 2025  
**Tags:** UI/UX IMPROVEMENTS, MEGA MENU, NAVBAR FIXES, DARK MODE, DEFAULT PAGES, SEO OPTIMIZATION, FLOATING CHAT, BINARY TRADING

## Fixed

### Navbar Logo Display
- **Full Logo Display**: Fixed navbar logo appearing as small square when "Full Logo Only" setting was selected
- **Dynamic Sizing**: Logo now properly displays at appropriate size (h-8 lg:h-10) with auto width
- **Aspect Ratio**: Maintained correct aspect ratio for text logos (180x48) instead of constrained square dimensions
- **Component Classes**: Updated NavbarLogo component to respect display settings without forcing square dimensions

### Admin Mega Menu Layout
- **Menu Width**: Increased mega menu width to accommodate longer menu items like "Transaction Management"
- **Dynamic Width**: Changed from fixed min-width to dynamic max-width (90vw) to prevent overflow on smaller screens
- **Left Panel**: Adjusted left panel width from 280px to 250px with proper min-width constraints
- **Right Panel**: Set minimum width of 350px for content area to ensure readability
- **Icon Sizing**: Added `flex-shrink-0` to prevent icons from shrinking on hover
- **Text Wrapping**: Added `whitespace-nowrap` to prevent unwanted text wrapping in menu items

### Binary Trading Dark Mode
- **Theme Persistence**: Fixed navbar showing in light mode when dark mode was active on /binary page
- **Immediate Application**: Added theme synchronization to prevent flash of wrong theme on page load
- **Theme Toggle**: Enhanced theme toggle to immediately apply changes without delay
- **HTML Class Management**: Properly manages dark/light classes on HTML element for consistent theming

### Floating Support Chat
- **Page Exclusions**: Hidden floating support button on /trade and /binary pages as requested
- **Trading Interface**: Removed distracting chat widget from trading pages for cleaner interface
- **Conditional Rendering**: Added page path checking to FloatingChatProvider component

### Binary Orders Menu Icon
- **Missing Icon**: Added `tabler:binary-tree` icon to Binary Orders menu item in admin navigation
- **Consistent Icons**: Ensured all admin menu items have appropriate icons for better visual hierarchy

### Default Pages Rendering
- **Content Fetching**: Fixed pages not fetching content from the correct API endpoint
- **API URL**: Corrected to use `/api/content/default-page/[pageId]` instead of admin endpoint
- **Port Configuration**: Smart detection of development vs production environment for API URLs
- **Development**: Uses `NEXT_PUBLIC_BACKEND_URL` (localhost:4000)
- **Production**: Uses `NEXT_PUBLIC_SITE_URL` without separate port

### Default Pages Styling
- **Background Color**: Fixed pages not using proper zinc background from layout
- **Text Styling**: Applied proper Tailwind classes to all HTML elements from editor
- **Dark Mode Support**: Ensured proper dark mode styling with bg-background class
- **Title Display**: Page titles now display prominently with proper styling
- **Title Spacing**: Increased margin below title (mb-12 mobile, mb-16 desktop) for better readability

### Default Editor Background
- **Unnecessary Background**: Removed hardcoded background colors from default editor pages
- **Layout Consistency**: Editor pages now use parent layout background for consistency

## Improved

### Logo System
- **Size Optimization**: Improved Logo component to handle both icon and text logos appropriately
- **Dynamic Dimensions**: Text logos use 180x48 dimensions for better clarity
- **Class Inheritance**: Logo component now properly respects className prop for flexible sizing

### Mega Menu User Experience
- **Visual Feedback**: Added background color (bg-muted/20) when no items are hovered
- **Content Padding**: Optimized padding (p-4 instead of p-6) for better space utilization
- **Item Spacing**: Improved spacing between menu items for better scanability
- **Overflow Protection**: Added overflow-x-auto to handle edge cases gracefully

### Default Pages Architecture
- **Server Components**: Converted from client to server components for better performance
- **SEO Metadata**: Implemented dynamic metadata generation from editor content
- **Reusable Components**: Created shared DefaultPage component for consistency
- **Content Processing**: Smart content processor that preserves editor formatting while adding styles

### Content Editor Integration
- **Exact Content Rendering**: Pages now display exactly what's entered in the editor
- **No Fallback Content**: Removed hardcoded fallback content (except home page template)
- **Plain Text Support**: Automatically wraps plain text in proper paragraph tags
- **HTML Processing**: Only adds classes to elements without existing styles

### SEO Implementation
- **Dynamic Metadata**: Pages fetch SEO data from backend and apply to page metadata
- **Fallback Values**: Graceful fallback to default SEO values if API data unavailable
- **Keywords Support**: Full support for title, description, and keywords metadata

### Developer Experience
- **Environment Detection**: Automatic environment detection for API URLs
- **Debug Logging**: Added console logging for troubleshooting content fetching
- **Error Handling**: Improved error messages and recovery strategies
- **Code Organization**: Centralized page utilities in default-page.tsx component

## Technical Details

### New Components
- **default-page.tsx**: Reusable component for rendering default pages with consistent styling
- **processContent()**: Function to apply Tailwind classes to HTML content from editor
- **generatePageMetadata()**: Dynamic SEO metadata generation from backend
- **getPageContent()**: Centralized content fetching with proper error handling

### API Integration
- **Public Endpoint**: Uses `/api/content/default-page/[pageId]` for content fetching
- **Cache Busting**: Adds timestamp parameter to prevent stale content
- **Headers**: Proper cache control headers for fresh content
- **Error Recovery**: Graceful handling of API failures with user-friendly messages

### Styling System
- **Tailwind Classes**: Comprehensive class application for all HTML elements
- **Dark Mode**: Full dark mode support with proper color tokens
- **Responsive Design**: Mobile-first approach with responsive spacing
- **Typography**: Consistent typography scale across all content

### Performance Optimizations
- **Server-Side Rendering**: Default pages now use SSR for better SEO and performance
- **No Client-Side Fetching**: Content fetched at build/request time
- **Reduced JavaScript**: Minimal client-side JavaScript for static content
- **Optimized Images**: Proper image sizing and loading strategies

### Binary Trading Enhancements
- **Theme Consistency**: Ensured dark mode persists across all trading interfaces
- **Clean Interface**: Removed unnecessary UI elements from trading pages
- **Focus Mode**: Trading pages optimized for distraction-free trading

### Navigation Improvements
- **Icon Consistency**: All menu items have appropriate icons
- **Visual Hierarchy**: Better organization with icons and proper spacing
- **Responsive Behavior**: Menu adapts properly to different screen sizes

## Migration Notes

### For Developers
- Default pages now fetch from `/api/content/default-page/[pageId]` instead of admin endpoints
- Environment variables properly configured for dev/prod API URLs
- All default pages converted to server components

### For Users
- Default pages will now display exactly what's entered in the editor
- SEO settings from editor are properly applied
- Dark mode works consistently across all pages
- Improved loading performance for default pages

## DataTable Drawer Improvements

### Fixed Dropdown Scrolling in Drawers
- **Mouse Wheel Scrolling**: Fixed issue where dropdowns in DataTable edit/create drawers wouldn't scroll with mouse wheel
- **Vaul Drawer Compatibility**: Added `data-vaul-no-drag` attribute to prevent drawer from intercepting scroll events
- **Z-Index Management**: Increased dropdown z-index from z-[75] to z-[100] to ensure proper layering above drawer content
- **Event Propagation**: Added `onWheel` event handlers to stop scroll event propagation and allow normal scrolling
- **Multi-Select Support**: Applied fixes to both Select and MultiSelect form controls for consistent behavior
- **Scroll Prevention**: Drawer no longer captures scroll events intended for child dropdown components

### Mobile Sidebar Extension Handling
- **Disabled State Consistency**: Fixed mobile sidebar not respecting disabled extension states like desktop mega menu
- **Extension Accessibility**: Disabled extensions are now properly non-clickable and visually dimmed in mobile menu
- **Visual Feedback**: Added `opacity-60 cursor-not-allowed` styling to disabled extension items
- **Background Styling**: Disabled items use `bg-muted/20` background to match desktop mega menu behavior
- **Child Menu Support**: Extended disabled state handling to nested/child menu items

### Extension Icons in Mobile Menu
- **Missing Icons**: Extensions in mobile sidebar now properly display icons consistently with desktop
- **Icon Source Fix**: Changed Extensions menu icon from `solar:puzzle-bold-duotone` to `ph:puzzle-piece-duotone` for better compatibility
- **Visual Hierarchy**: All extension menu items now show appropriate icons for better navigation
- **Iconify Integration**: Ensured proper icon rendering through Iconify React component

### Demo Data Foreign Key Constraints
- **ICO User References**: Fixed ICO demo data foreign key constraint failures by using valid user ID `fbe0aaf7-4321-4a40-84a1-b4321d557033`
- **Token Offerings**: All 7 ICO token offerings now reference existing user accounts
- **Transaction Records**: Updated 5 ICO transaction records to use correct user IDs
- **Database Integrity**: Eliminated SQL import errors related to non-existent user references

### Password Reset Flow
- **Correct URL Routing**: Fixed profile security tab logout and reset password button to redirect to `/reset` instead of non-existent `/auth/reset`
- **Login Page Reference**: Updated security instructions to reference correct `/login` path instead of `/auth/login`
- **Auth Modal Integration**: Reset password page properly triggers auth modal with forgot-password flow when no token is provided

## Settings Organization Improvements

### Spot Trading Settings Relocation
- **Moved from Wallet to Trading**: Spot Exchange setting relocated from "Wallet > Wallet Types" to "Features > Trading" for better logical organization
- **Renamed for Clarity**: Changed from "Spot Exchange" to "Spot Trading" for clearer terminology
- **Description Update**: Updated description to "Enable spot trading functionality" for better understanding
- **Settings Order**: Spot Trading now appears before Chart Type in the Trading subcategory
- **Tab Naming**: Improved Features tab label to "Trading & Features" to better reflect its content

## Homepage Layout Improvements

### Markets Section Image Sizing
- **Fixed Circular Shape**: Added `min-w-[2rem] min-h-[2rem]` to maintain circular shape on all screen sizes
- **Prevent Shrinking**: Added `flex-shrink-0` to prevent container from becoming pill-shaped
- **Consistent Sizing**: Images now maintain proper dimensions even when parent container is compressed
- **Removed Redundant Styles**: Cleaned up unnecessary `rounded-full` and height auto styles from image element

### Responsive Layout with Spot Trading Disabled
- **Dynamic Content Width**: Content now expands to full width when spot trading/markets section is hidden
- **Centered Layout**: Hero content properly centers when markets section is disabled
- **Conditional Alignment**: Text alignment, buttons, and features adjust based on spot trading status
- **Maximum Width**: Content uses `max-w-4xl` for optimal readability when centered
- **Visual Balance**: Eliminates awkward empty space on the right when markets are hidden

## WebSocket Connection Improvements

### Fixed Undefined User ID Connection
- **Connection Guard**: WebSocket connection now only establishes when a valid user ID is present
- **Provider Protection**: WebSocketProvider component conditionally renders based on profile.id existence
- **Safety Check**: Added additional validation in WebSocketProvider to prevent connection with undefined userId
- **Console Warning**: Logs warning message when WebSocket connection is skipped due to missing userId
- **Error Prevention**: Eliminates `ws://localhost:4000/api/user?userId=undefined` connection attempts

### Support Chat Widget Size Optimization
- **Button Size Reduction**: Reduced floating support button from 64x64px (h-16 w-16) to 48x48px (h-12 w-12)
- **Icon Adjustment**: Scaled down MessageCircle icon from 28x28px to 20x20px for proportional appearance
- **Less Intrusive**: Smaller widget provides better user experience without blocking content
- **Maintained Functionality**: All hover effects, animations, and gradients preserved with smaller size