# Version 5.4.3

**Release Date:** August 18, 2025  
**Tags:** BUG FIXES, CHART IMPROVEMENTS, USER MANAGEMENT FIXES

## Fixed

### Binary Trading Performance
- **Order Updates**: Optimized interval to only run when active orders exist
- **Real-time Updates**: Maintained 1-second updates for profit/loss and timers
- **Memory Management**: Fixed requestAnimationFrame cleanup to prevent memory leaks
- **CPU Usage**: Reduced by 30-40% during idle states with no active orders
- **WebSocket Optimization**: Reduced unnecessary re-renders from data updates

### Dialog Accessibility
- **Missing Descriptions**: Fixed missing DialogDescription warnings
- **ARIA Attributes**: Added proper aria-describedby to all Dialog components
- **Screen Readers**: Added accessible descriptions for all modal dialogs
- **WCAG Compliance**: Improved accessibility standards compliance

### Investment Dashboard
- **Array Error**: Fixed "TypeError: r.find is not a function" error
- **API Response**: Fixed handling to properly extract array data
- **Defensive Checks**: Added fallback to empty array for unexpected data structures
- **Runtime Protection**: Prevented errors when API returns non-array responses

### Wallet Type Translations
- **Display Names**: Fixed untranslated wallet type names (SPOT_WALLETS, etc.)
- **Translation Keys**: Added proper translations for all wallet types
- **Wallet Details**: Updated page to use translation keys instead of raw type names

### Exchange Currency Withdrawals
- **Error Messages**: Improved "Exchange currency not found" to specify which currency
- **Wallet Errors**: Enhanced messages to specify currency and wallet type
- **User Guidance**: Added instructions to contact support for unavailable currencies

### Binary Trading Charts
- **Chart Aspect Ratio**: Fixed chart displaying as square instead of proper ratio
- **Height Issues**: Resolved CSS height conflicts in chart container hierarchy
- **Active Order Lines**: Fixed lines showing at wrong price positions
- **Position Markers**: Fixed Y-axis calculation and timestamp conversions
- **Expired Orders**: Fixed cleanup of expired orders without results

### Binary Trading Panels
- **Active Positions**: Fixed timer staying at 00:00 when positions expire
- **Completed Positions**: Fixed panel not showing when orders complete
- **Mini Charts**: Fixed profit/loss charts showing as squares instead of line charts
- **Panel Resizing**: Added resizable functionality with persistent height preference

### TradingView Integration
- **Chart Support**: Added TradingView chart support to binary trading page
- **Chart Switcher**: Implemented component to toggle between Native and TradingView
- **Settings Integration**: Integrated with system settings for chart type selection
- **Loading Optimization**: Prevented unnecessary chart loading before settings fetch

### Advanced Chart Mobile
- **Pinch-to-Zoom**: Fixed inverted zoom direction on mobile devices
- **Touch Events**: Added preventDefault to avoid browser's default zoom
- **Drag Sensitivity**: Adjusted PC (30%) and mobile (20%) drag sensitivity
- **Hardware Acceleration**: Added classes for better performance during pinch

### User Management
- **CSV Import**: Fixed "No CSV file uploaded" error when uploading CSV files
- **Import/Export Buttons**: Fixed buttons disappearing on page refresh
- **Data Processing**: Fixed NULL values for firstName and lastName fields
- **Column Mapping**: Added case-insensitive CSV header mapping
- **BOM Removal**: Added Byte Order Mark removal for UTF-8 files

## Improved

### Binary Trading UX
- **Resizable Panels**: Drag resize handle to adjust panel height (200px to 800px)
- **Persistent Preferences**: Height preferences saved using localStorage
- **Visual Feedback**: Smooth resize operation with hover effects
- **Space Optimization**: Compacted UI to display 8-10 orders instead of 1-2
- **Status Badges**: Simplified to single letters (W/L) for space efficiency

### Order Management
- **Auto-Fetch**: Orders automatically fetched when switching symbols
- **Symbol Changes**: Fixed order fetching to trigger when symbol is set
- **API Endpoints**: Corrected endpoints with proper type parameters
- **Debug Logging**: Added console logging for order fetch operations

### Error Handling
- **Detailed Messages**: Enhanced error messages with validation information
- **User Feedback**: Improved error display with actionable guidance
- **Cache Management**: Disabled problematic caching for permission consistency