# Version 5.2.1
**Release Date:** June 27, 2025  
**Tags:** BUILDER SYSTEM, AUTHENTICATION, TRADING INTERFACE, TEMPLATE SYSTEM

## Fixed

### Builder System
- **Margin Display Issue**: Fixed issue where text elements showed incorrect margin values in edit mode, making it impossible to modify spacing
- **Value Calculation Errors**: Resolved calculation errors in margin/padding that were breaking element editing
- **Element Initialization**: Fixed builder element initialization to provide proper default settings for text elements

### Authentication System
- **Two-Factor Authentication**: Fixed authentication system failure that was preventing 2FA login
- **Token Generation**: Enhanced authentication token generation with better error handling and fallback mechanisms
- **Crypto Module**: Fixed authentication token generation failures

### Trading Interface Market Switching
- **Market Data Contamination**: Fixed issue where switching markets caused old market data to persist and contaminate new market display
- **Chart Data Cleanup**: Previous market's candle data no longer shows on new market charts
- **Price Data Reset**: Old market prices no longer display on new market panels
- **WebSocket Subscription Management**: Proper cleanup of old market subscriptions prevents data leaks

### TradingView Chart Integration
- **WebSocket Unsubscribe**: Fixed TradingView chart not properly unsubscribing when changing markets
- **Live Data Flow**: Restored live candle updates after market switches
- **Memory Leak Prevention**: Eliminated orphaned WebSocket subscriptions

### Mobile Trading Interface
- **Market Switching**: Enhanced mobile market switching with proper cleanup system
- **Chart Remounting**: Improved chart component behavior on mobile devices
- **Performance Optimization**: Reduced unnecessary re-renders on mobile

### Translation System
- **Bad Key Management**: Implemented automated bad translation key detection and fixing system
- **Key Validation**: Fixed problematic translation keys that were causing display issues

## Enhanced

### Builder Interface
- **Margin/Padding Visibility**: Enhanced spacing visibility logic to provide better visual feedback when editing element properties
- **Element Templates**: Updated text element templates with appropriate default spacing for consistent typography
- **Visual Feedback**: Improved display logic to provide clearer visual indicators when editing spacing properties

### Authentication Experience
- **Key Format Handling**: Strengthened authentication system to handle multiple secret key formats
- **Error Recovery**: Enhanced token generation with graceful error handling to prevent system failures
- **Security Robustness**: Maintained encryption requirements while adding flexibility for different input formats

### Navigation Menu
- **Menu Organization**: Moved P2P from standalone menu item to "P2P Trading" under Trade category
- **Logical Grouping**: All trading-related features now organized in one category
- **Improved Navigation**: Better structure for trading functionalities

### Trading Interface Performance
- **Market Switching Architecture**: Implemented comprehensive cleanup system for faster market transitions
- **Memory Efficiency**: Prevents subscription leaks and memory bloat
- **Performance Optimization**: Faster market switching with proper component cleanup

## Added

### Builder Template System
- **Complete Template Overhaul**: Added 22 new modern, professional section templates organized across 10 categories

### Hero Sections
- **Trading Hero**: Advanced trading platform hero with animations and modern design elements
- **Crypto Hero**: Cryptocurrency-focused hero section with dark theme and professional typography
- **Investment Hero**: Professional investment-focused layout with clean design
- **Modern Hero**: Minimalist hero design with contemporary styling

### Feature Sections  
- **Trading Features**: Comprehensive trading platform feature showcase with icons and descriptions
- **Security Features**: Security-focused section highlighting platform safety measures
- **Platform Features**: General platform capabilities with modern card-based layout

### Statistics Sections
- **Trading Stats**: Real-time trading statistics with animated counters and professional metrics
- **Performance Stats**: Platform performance metrics with visual indicators
- **Global Stats**: Worldwide platform statistics with geographic data visualization

### Additional Sections
- **Client & Trader Testimonials**: Professional testimonial sections with ratings and success stories
- **Premium & Trading Plans**: Subscription and trading-specific pricing tiers with feature comparisons
- **Company Story & Team**: About sections focusing on company history and team profiles
- **Contact & Support**: Modern contact forms and support sections with multiple communication channels
- **Call-to-Action Sections**: Platform registration and trading-focused CTA sections
- **News & Updates**: Platform updates, market news, and announcement sections
- **Learning Resources**: Educational content with courses, tutorials, and trading guides 