# Version 5.1.5
**Release Date:** June 24, 2025  
**Tags:** CRITICAL FIXES, NEW FEATURES, MOBILE ENHANCEMENTS

## Added

### TradingView Advanced Charting Integration
- **Chart Switcher System**: Added new admin setting to switch between Native Chart and TradingView Advanced charting
- **TradingView Component**: Created TradingView chart component with full datafeed integration for real-time market data
- **Exchange Provider Support**: Added support for multiple exchange providers (Binance, KuCoin) with proper resolution mapping
- **Professional Features**: Real-time OHLCV data streaming, multiple timeframe support, dark/light theme synchronization, mobile-responsive configuration
- **Automatic Fallback**: Automatic fallback to native chart if TradingView library is not available

## Fixed

### Authentication & Password Reset System
- **Password Reset Flow**: Fixed "This page could not be found" error when clicking password reset links from email
- **Token Validation**: Fixed "Invalid request body: Schema validation error" when submitting password reset form
- **Timeout Issues**: Fixed "Verification timed out" error that appeared after a few seconds on password reset page
- **Form Optimization**: Optimized password reset form submission process

### Binary Trading Improvements
- **Order Confirmation**: Fixed issue where clicking the confirmation button multiple times could create duplicate orders
- **Processing State**: Added processing state management with button disabling and loading indicator during order placement
- **Auto-countdown**: Auto-countdown now pauses during processing to prevent conflicts with manual confirmation

### Login & Modal System
- **Modal Redirect Issue**: Fixed issue where clicking outside the login modal would redirect users to the home page
- **Enhanced UI**: Added "Open Login Form" button that appears when modal is closed, allowing users to easily reopen it
- **User Experience**: Users can now dismiss the modal without being forced to leave the login page

### Mobile Navigation & Layout
- **Bottom Tabs Visibility**: Fixed issue where bottom navigation tabs were cut off on small mobile devices
- **Dynamic Viewport Height**: Implemented dynamic viewport height calculation using JavaScript to detect actual available screen space
- **Safe Area Handling**: Enhanced mobile layout with proper safe area handling for devices with notches or home indicators
- **Binary Trading Mobile**: Applied same mobile height fixes to binary trading page to ensure consistent navigation visibility

### Chart System Enhancements
- **API Performance**: Fixed chart API endpoint hanging indefinitely
- **Duplicate API Calls**: Fixed duplicate API calls for historical chart data on mobile devices when loading or switching markets
- **TradingView Optimization**: Optimized TradingView DataFeed function to prevent recreation on every render
- **Theme Switching**: Improved TradingView theme switching to use built-in methods

### Backend Performance & Concurrency
- **API Concurrency**: Fixed backend hanging when multiple concurrent chart API requests are made
- **Request Deduplication**: Implemented request deduplication to prevent duplicate API calls for identical chart data requests
- **Timeout Management**: Added comprehensive timeouts to all operations

### Build & Environment Issues
- **Build Environment Variables**: Fixed Next.js build failing with destination errors
- **KYC Build Error**: Fixed build failure during installation
- **Environment Fallbacks**: Added proper fallback values for all critical environment variables

### Installation System Improvements
- **Database Seeding**: Fixed database seeding errors during installation process
- **Permission Management**: Fixed permissions at critical points during installation
- **Schema Import**: Fixed database schema import issues
- **Installation Sequence**: Installation now follows correct sequence

### UI & Visual Fixes
- **KYC Button**: Fixed "Create Level" button text color not being white in dark mode on KYC verification levels page
- **Dark Mode**: Added proper text visibility classes for both themes

## Enhanced

### Mobile Experience Optimization
- **Dynamic Height Calculation**: Enhanced mobile layout with proper viewport height calculation that adapts to browser UI changes
- **Safe Area Integration**: Added CSS custom properties that update in real-time based on actual viewport dimensions
- **Touch-Friendly Design**: Increased tab height on mobile for better touch targets with enhanced tab styling
- **Orientation Support**: Added orientation change detection with proper height recalculation

### Chart Performance & Integration
- **Initialization Optimization**: Charts now initialize only once per symbol change and handle market type/theme changes efficiently
- **Mobile Chart Keys**: Updated mobile layout chart key to use only symbol to prevent unnecessary remounting

### Backend Architecture
- **Concurrency Control**: Added concurrency control to ExchangeManager with proper queue management for simultaneous exchange initialization
- **Error Handling**: Enhanced error handling with graceful fallbacks to cached data when real-time data is unavailable
- **Resource Management**: Optimized resource management with proper cleanup and timeout handling 